; SAVE#D:MYRDA.M65
; REN100,10
; ASM,,#D:TEST.AR0
; LIST460
;
    .SET 2,180
    .SET 3,0
    .SET 4,117
    .OPT NO LIST
    .OPT NO EJECT
    .TITLE "MyRD RAMDISK INSTALLER"
;
;  MYDOS 4.3 RAMDISK INSTALLATION PROGRAM
;
;
;*******************************
;*This file was heavily Modified
;*from RAMBOOT3.  Coments on bug
;*fixes and added code will
;*start with * and be in lower
;*case.  Thanks go to John
;*and Master debugger Mathy
;*THANKS guys - Lee
;*****************************
;*****************************
;
;*further I've combined myrd
;*and myrd2 into one source
;*code file so that one source
;*assembles both versions. If
;*you want just myrd version
;*without autoconfigure set the
;*following myrd2 equate to zero
;*myrd2 = 1 and you get auto
;*myrd2 = 0 and you don't
;*
MYRD2 = 1
;
;
;  LOCAL ZERO PAGE RAM
;
IOCBZ = $20
    *=  $D4
PTR *=  *+2
NAMPTR *= *+2
CLSFLG *= *+1
BOTHOK *= *+1
SVIOCB *= *+16
;
;  SYSTEM EQUATES
;
MEMTOP = $02E5
CRSINH = $02F0  ;* cursor inhib
HATAB = $031A
ICMD =  $0342
ISTAT = $0343
IBUF =  $0344
ILEN =  $0348
IAUX =  $034A
BASICF = $03F8  ;* BASIC flag
;
;  MYDOS SYSTEM DEFINITIONS
;
RAMDKU = $070A
DOSEND = $070C  ;*
STATE = $07BE   ;* corrected
RDTEST = $0730
CTEST = $0736
;
;  HARDWARE AND OS ROM DEFINITIONS
;
PAGE40 = $4000
PORTB = $D301
AXLON = $CFFF
CIOV =  $E456
;
;  MISCELLANEOUS DEFINITIONS
;
IOCB =  $20     ;FREE IOCB FOR MY USE
;*
;*
;*
;*
    *=  $0400
;*
CLR
    LDA DOSEND  ;*
    STA $E0     ;*
    LDA DOSEND+1 ;*
    STA $E0+1   ;* clear
    LDA #$00    ;* mem.sav
    TAY         ;* area for
    LDX #$35    ;* super clean
?C
    STA ($E0),Y ;* first
    INY         ;* mem.sav
    BNE ?C      ;* file for
    INC $E1     ;* booting with
    DEX         ;* BASIC on
    BNE ?C      ;*
    LDY #$01    ;* cursor
    TYA         ;* make SIO OK
    CLC         ;* and return
    RTS         ;* to DOS
;
FLAG88 = *      ;* for AK's large file load fix
;
;*
;*
;*
;*
;
    *=  $2DBF   ;* was 3000
;
RDKLMT
    .BYTE 6     ;* but needed
MAPAGE *= *+64  ;* room for
MAPBUF *= *+512 ;* these buffers
;
;
; CLOSE ANY IOCB
;
CLOSE
    LDA #12     ;CLOSE ANY IOCB
    STA ICMD,X
    JMP CIOV
;
; OPEN FILE
;
; CALLING SEQUENCE:
;    JSR SOPEN
;  .BYTE AUX
;  .BYTE CMD
;  .WORD BUFFER ADDRESS
;
SOPEN
    SEC 
    .BYTE $A9   ;LDA #IMM OPCODE
;
; DO A READ/WRITE TYPE I/O REQUEST
;
; CALLING SEQUENCE:
;    JSR DOIO
;  .BYTE IOCBNO
;  .WORD BUFFER LENGTH
;  .BYTE CMD
;  .WORD BUFFER ADDRESS
;
DOIO
    CLC 
    PLA 
    STA PTR
    PLA 
    STA PTR+1
    LDY #1
    LDA (PTR),Y
    BCC DOIO1
    STA IAUX,X
    BCS XTRCB
DOIO1
    TAX 
    INY 
    LDA (PTR),Y
    STA ILEN,X
    INY 
    LDA (PTR),Y
    STA ILEN+1,X
XTRCB
    INY 
    LDA (PTR),Y
    STA ICMD,X
    INY 
    LDA (PTR),Y
    STA IBUF,X
    INY 
    LDA (PTR),Y
    STA IBUF+1,X
    TYA 
    CLC 
    ADC PTR
    TAY 
    LDA #0
    ADC PTR+1
    PHA 
    TYA 
    PHA 
    JSR CIOV    ;DO I/O REQUEST
    BPL NOIOER  ;NO ERROR?
    CPY #$88
    BEQ NOIOER  ;MAYBE EOF?
    PLA 
    PLA         ;NO, DISCARD RETURN ADDR AND EXIT
    TYA 
NOIOER
    RTS 
;
;  CHECK FOR EXTENED MEMORY
;
;
;*
;* This whole block 'borrowed'
;* from MyDOS DUP code - Its an
;* auto detect for ramdisks
;*
; 
RECONRAM
    LDY #0
    LDA $D301
    PHA 
    LDX #$FF
CKBL1
    STY $CFFF
    LDA $4000
    STA MAPBUF,Y
    STX $4000
    TXA 
    STA MAPBUF+256,Y
    INY 
    BNE CKBL1
    DEX 
    STX $4000
    LDX #0
CKBL2
    STY $CFFF
    LDA $4000
    CMP #$FF
    BNE CKBNOT
    INX 
    STX $4000
    TXA 
CKBNOT
    STA MAPBUF+256,Y
    INY 
    BNE CKBL2
    STX RDKLMT
;
    LDX #1
CKBL8
    TXA 
    LDY #$FF
CKBL6
    CMP MAPBUF+256,Y
    BEQ CKBFO
    DEY 
    CPY #$FF
    BNE CKBL6
;              
CKBL9
    STY $CFFF
    LDA MAPBUF,Y
    STA $4000
    DEY 
    CPY #$FF
    BNE CKBL9
    PLA 
    STA $D301
    LDA #$C0
    STA $D40E
    LDA $10
    STA $D20E
    CLI 
    LDA #$22
    STA $022F
    LDX RDKLMT
    RTS 
;
CKBFO
    TYA 
    STA MAPAGE-1,X
    INX 
    CPX #65
    BCC CKBL8
    LDY #$FE
    BNE CKBL9
;
;
;*  CHECK FOR 130XE
;
DO130
    LDA #'1
    STA NAMEDK
    LDA #'3
    STA NAMEDK+1
    LDA #'0
    STA NAMEDK+2
    LDA #'X
    STA NAMEDK+3
    LDA #'E
    STA NAMEDK+4
    LDA # >PORTB
    LDY # <PORTB
    STY CKBL1+1
    STA CKBL1+2
    STY CKBL2+1
    STA CKBL2+2
    STY CKBL9+1
    STA CKBL9+2
    STY TARG1+1
    STA TARG1+2
    STY TARG3+1
    STA TARG3+2
    LDA #$FF
    STA TARG3-1
    SEI 
    LDY #0
    STY $D40E
    STY $D20E
    JMP RECONRAM
;
;
CHKBANKS
    JSR RECONRAM
    BEQ GO130
?L5
    TXA         ;* working
    STA MAPAGE-1,X ;*
    DEX         ;*
    BNE ?L5     ;*
    BEQ ?1
GO130
    LDA #0
    STA $022F
    LDA $14
LOOP14
    CMP $14
    BEQ LOOP14
    JSR DO130
;
; *
; This routine sets up TESTRD
; for a test of a previous
; ramdisk installed
;
RETRAM
    BNE ?1      ;* return if no
    RTS         ;* ramdisk
;
?1
    LDA # <$0D00
    STA PTR
    LDA # >$0D00
    STA PTR+1
    LDA # <TSTRING1
    STA NAMPTR
    LDA # >TSTRING1
    STA NAMPTR+1
    LDY #$05
?2
    LDA (PTR),Y
    CMP (NAMPTR),Y
    BNE DECPTR
    DEY 
    BNE ?2
    BEQ GOODL
DECPTR
    LDY #$05
    DEC PTR
    LDA PTR
    CMP #$FF
    BNE ?2
    DEC PTR+1
    BNE ?2
;
;* The routine above finds a
;* string of relevant ramdisk
;* code within MyDOS to locate
;* the banking register address
;* ie - D301 or CFFF
;*
      .IF MYRD2=1
GOODL
      LDY #$07
      LDA RDKLMT ;* stores rd size
      STA (PTR),Y ;* into dos.sys
      LDY #0
      .ELSE 
GOODL
      .ENDIF 
;
?3
    LDA (PTR),Y
    CMP #$48    ;* PHA=end of
    BNE DECPTR2 ;* bank table+1
;
      .IF MYRD2=1 ;** myrd2 only below
;
      LDY #31   ;$1f
      LDA TARG3+1 ;** move detected
      STA (PTR),Y ;** bank address
      LDA TARG3+2 ;** into MyDOS
      INY       ;** ramdisk
      STA (PTR),Y ;** handler
      LDY #82   ;$52
      LDA TARG3+1
      STA (PTR),Y
      LDA TARG3+2
      INY 
      STA (PTR),Y
      LDY #21   ;$15
      CMP #$CF  ;** axlon further
      BNE ?12   ;** gets 'lda 00'
      LDA #$A9  ;** instruction for
      STA (PTR),Y ;** home page
      INY 
      LDA #$00
      STA (PTR),Y
      BEQ ?13
?12
      LDA #$EA  ;** 130XE gets two
      STA (PTR),Y ;** NOPs
      INY 
      STA (PTR),Y
?13
;
      .ENDIF 
;
    SEC 
    LDA PTR
    SBC #65     ;** move pointer
    STA PTR     ;** to beginning
    LDA PTR+1   ;** of banking
    SBC #0      ;** bytes table
    STA PTR+1
      .IF MYRD2=1 ;** myrd2 only below
      LDY #$40
?52
      LDA #0
      STA (PTR),Y
      DEY 
      BNE ?52
      LDY RDKLMT
?5
      LDA MAPAGE-1,Y
      STA (PTR),Y
      DEY 
      BNE ?5
      .ENDIF    ;** both versions below
;
    LDY #1
    LDA (PTR),Y ;* get 1st ramsector
    STA TARG1-1 ;* page's byte (bba)
    LDX RDKLMT
    RTS 
;
DECPTR2
    DEC PTR
    LDA PTR
    CMP #$FF
    BNE ?3
    DEC PTR+1
    BNE ?3
;
;*
;* The above routine store both
;* the banking register address
;* and the first banking byte
;* into the TSTRD routine for
;* testing of and setting of
;* future or previous ramdisk
;
NEXTF
    LDA # <UFILE
    STA IBUF+$30
    LDA # >UFILE
    STA IBUF+1+$30
    LDA #5
    STA ICMD+$30
    LDA #0
    STA ILEN+$30
    LDA #1
    STA ILEN+1+$30
    LDX #$30
    JSR CIOV
    SEC 
    BMI NEXTFX
    LDA UFILE
    CMP #'0
    BCS NEXTFX
    LDX #0
    LDY #2
CPL1
    LDA UFILE,Y
    CMP #'0
    BCC DOEXT
    STA RFNAME,X
    INX 
    INY 
    CPY #10
    BCC CPL1
DOEXT
    LDA UFILE+11
    CMP #$20    ;space
    BEQ EXTEX
    LDA #'.
    STA RFNAME,X
    INX 
    LDY #10
CPL2
    LDA UFILE,Y
    CMP #'0
    BCC EXTEX
    STA RFNAME,X
    INX 
    INY 
    CPY #13
    BCC CPL2
EXTEX
    LDA #0
    STA RFNAME,X
;
    LDX #0
CPL3
    LDA RFNAME,X
    STA NDUP8+3,X
    STA BLNK+12,X ;* save fname
    BEQ CPXIT
    INX 
    BNE CPL3
;
CPXIT
    LDA #$9B    ;* end char to
    STA BLNK+12,X ;* end put
    LDA # <RDDIR
    STA IBUF+$10
    LDA # >RDDIR
    STA IBUF+1+$10
    LDA # <NDUP8
    STA IBUF+$20
    LDA # >NDUP8
    STA IBUF+1+$20
    CLC 
NEXTFX
    RTS 
;
;  COPY A SINGLE FILE FROM D1:RAMDISK:** TO THE RAMDISK
;
COPY
    JSR DOIO    ;* put files
    .BYTE 0     ;* being copied
    .WORD 30    ;* to screen
    .BYTE 9     ;*
    .WORD BLNK  ;*
    LDX #$10
    LDA #4      ;* Read
    STA IAUX,X
    LDA #3      ;* Open for read #10
    STA ICMD,X
    JSR CIOV
    BMI CLOSIT
    LDX #$20
    LDA #8      ;* Write new
    STA IAUX,X
    LDA #0
    STA FLAG88  ;* zero flag here at setup for each file - AK
    STA IAUX+1,X
    LDA #3      ;* Open for write new file #20
    STA ICMD,X
    JSR CIOV
    BMI CLOSIT
    LDA IBUF+$20
    STA BFSAV
    LDA IBUF+1+$20
    STA BFSAV+1
COPYL
    LDX #$10
    LDA #7      ;* Get binary
    STA ICMD,X
    LDA # <BSS
    STA IBUF,X
    LDA # >BSS
    STA IBUF+1,X
    LDA BUFLEN
    STA ILEN,X
    LDA BUFLEN+1 ;** added +1
    STA ILEN+1,X
    JSR CIOV
;*       BPL COPYFL         ;* Andreas Koch (AK) needs to load huge
    CPY #$88
    BNE PLUS5   ;*
    INC FLAG88  ;* file that takes multiple passes
    BNE COPYFL  ;* but this code didn't use to support
;*          BNE CANTCP         ;* doing that
PLUS5 ;         * but now it does, psst broken Marslett code fixed!
    BMI CLOSIT  ;* ICSTA don't hold EOF 88, only register Y does
COPYFL
    LDX #$20
    LDA ILEN-$10,X
    STA ILEN,X
    LDA ILEN+1-$10,X
    STA ILEN+1,X
    LDA IBUF-$10,X
    STA IBUF,X
    LDA IBUF+1-$10,X
    STA IBUF+1,X
    LDA #11     ;* Put binary
    STA ICMD,X
    JSR CIOV
    BMI CANTCP
    LDA FLAG88  ;* more AK code
;*       LDA ISTAT+$10      ;* to wait for EOF (End of File)
;*       CMP #$88           ;* error code $88 - 136  otherwise,
    BEQ COPYL   ;* go back and get another file segment here
;*       BNE COPYL
CLOSIT
    LDX #$10
    LDA #12     ;* close
    STA ICMD,X
    JSR CIOV
    LDX #$20
    LDA #12     ;* close
    STA ICMD,X
    JSR CIOV
    RTS 
;
CANTCP
    JSR CLOSIT
    LDA BFSAV
    STA IBUF+$20
    LDA BFSAV+1
    STA IBUF+$20
    LDA #33
    STA ICMD+$20
    LDX #$20    ;DELETE COPY IF ERROR!
    JSR CIOV
    RTS 
;
?6C
    LDA #$FF    ;* clear ram at 0-10
    STA $E1     ;* for positive
    LDA #$11    ;* cold start action
    STA $E0     ;* for XEGS machine
    LDY #$EF    ;* stuck in boot
    LDA #0      ;* loops
?6D
    STA ($E0),Y ;* this does it
    INY         ;*
    BNE ?6D     ;* scramble rd 
    LDA $0BBA   ;* so myrd will
    STA $D301   ;* force format
    STA $CFFF   ;* next time
    STA $4018   ;* it boots
    STA $033D   ;* dito machine ram
    STY $CFFF
    JMP $E477   ;* coldstart vector
;
    .INCLUDE #D:MYRDB.M65
;
